/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.Minim;
import ddf.minim.ugens.UGen;

public class BitCrush
extends UGen {
    public UGen.UGenInput audio = new UGen.UGenInput(this, UGen.InputType.AUDIO);
    public UGen.UGenInput bitRes = new UGen.UGenInput(this, UGen.InputType.CONTROL);
    private float nLevels;
    private float halfNLevels;

    public BitCrush() {
        this(1.0f);
    }

    public BitCrush(float f) {
        this.bitRes.setLastValue(f);
        this.nLevels = (float)Math.floor(Math.pow(2.0, f));
        this.halfNLevels = this.nLevels / 2.0f;
        Minim.debug("bitCrush initializing to " + this.nLevels + " levels.");
    }

    public void setBitRes(float f) {
        this.bitRes.setLastValue(f);
    }

    @Override
    protected void uGenerate(float[] fArray) {
        float[] fArray2 = this.audio.getLastValues();
        for (int i = 0; i < fArray.length; ++i) {
            float f = this.bitRes.getLastValue();
            this.nLevels = (int)(f * f);
            this.halfNLevels = this.nLevels * 0.5f;
            float f2 = (float)Math.floor(this.halfNLevels * fArray2[i]);
            fArray[i] = f2 / this.halfNLevels;
        }
    }
}

